# Plugin to use github/gitlab as helm repo

This plugin makes it possible to use a private/public repository on github/gitlab as a helm repository also. You can keep the charts beside your code in the same repository.

## Why this plugin

Using git repo itself as the helm repo is better in my opinion because
- It will cut down the need of having one more component to serve the charts. One less webserver to deal with and making it highly available.
- No need of extra security layer to secure charts. They remain as secure as your code is. They use same authentication and authorisation as of your git repository.
- No dependence of extra storage layer like EBS, S3 and its security/replication.
- Charts live beside its code in the same repo and remain tightly version controlled with the code.

Helm allows adding http and https repositories. So public repositories are not a problem. But it does have any authentication/authorisation feature for adding/accessing the charts in the repository yet. Adding a private repo is not straight forward. You have to create private access token ([github](https://help.github.com/articles/creating-a-personal-access-token-for-the-command-line/)/[gitlab](https://docs.gitlab.com/ee/api/README.html#personal-access-tokens)) and embed directly in the URI of the repo. Example: https://gitlab.com/username/repo/raw/master/kubernetes/helm-chart?private_token=2xMusKyEgA7BRw5TaJYA. The problems with this approach are:
- Security. You will have to make sure that you keep the token secure all the time.
- Expiry. The token comes with a expiry. You will have to update the token in all repo's URI once it expires.
- Running `helm repo list` prints the token in plain text every time. There is no way to hide it.

You will have to make these compromises without this plugin. If you are able to, then there is no need of using the plugin otherwise this plugin solves these problems.

## Creating the helm repository

Lets say that this is structure of your repository
```
.
├── Dockerfile
├── README.md
├── kubernetes
│   └── helm-chart
│       └── myapplication
│           ├── Chart.yaml
│           ├── templates
│           │   ├── NOTES.txt
│           │   ├── _helpers.tpl
│           │   ├── deployment.yaml
│           │   └── service.yaml
│           └── values.yaml
├── src
└── tests
```

Run the following commands to create repo index
```bash
cd ./kubernetes/helm-chart
helm package myapplication # generates myapplication.tgz
helm repo index --url=gitlab://username/project:master/kubernetes/helm-chart . # generates index.yaml
```

Notice the url flag for `helm repo index` command. This is key for this plugin to work. The structure of the URI should be
provider://username/repository-name:branch/dir-containing-index.yaml

Commit the files generated by the helm commands and push to the repo. Now the repository is setup.

## Adding the helm repository

Before using the plugin, you need to setup your machine to access your private/public git repository without manual username-password input. Best is to setup ssh keys in [github](https://help.github.com/articles/adding-a-new-ssh-key-to-your-github-account/)/[gitlab](https://www.packtpub.com/mapt/book/application_development/9781783986842/2/ch02lvl1sec20/adding-your-ssh-key-to-gitlab)

On same or another computer which has the above requirement fulfilled, install the plugin

```bash
helm plugin install https://github.com/diwakar-s-maurya/helm-git
```

Now add the repo,
```bash
helm repo add myhelmrepo gitlab://username/project:master/kubernetes/helm-chart
helm repo list
```

Now that you have added the repository, start using it as any other regular repository.

```bash
helm install myhelmrepo/myapplication
```
